<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php

define('PLUGIN_PORTFOLIO',__('Portfolio','portfolio'));

class Portfolio_Plugin extends Pf_Plugin {

    public $name = 'Portfolio';
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the Portfolio description';

    public function activate() {
        $db = Pf::database();

        $sql = "DROP TABLE IF EXISTS `pf_portfolios`,`pf_portfolio_categories`,`pf_portfolio_meta`;";
        $db->query($sql);

        $db->query("CREATE TABLE `pf_portfolios` (
                        `portfolio_id` int(11) NOT NULL AUTO_INCREMENT,
                        `portfolio_name` varchar(50) NOT NULL,
                        `portfolio_status` tinyint(4) NOT NULL,
                        `portfolio_category` mediumint(9) NOT NULL,
                        `portfolio_avatar` varchar(100) NOT NULL,
                        `portfolio_description` longtext NOT NULL,
                        PRIMARY KEY (`portfolio_id`)
                       ) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8
                    ");
        $db->query("CREATE TABLE `pf_portfolio_meta` (
                        `meta_id` int(11) NOT NULL AUTO_INCREMENT,
                        `meta_portfolio` int(11) NOT NULL,
                        `meta_name` varchar(50) NOT NULL,
                        `meta_value` varchar(100) NOT NULL,
                        PRIMARY KEY (`meta_id`)
                       ) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8"
        );
        $db->query("CREATE TABLE `pf_portfolio_categories` (
                    `category_id` int(11) NOT NULL AUTO_INCREMENT,
                    `category_name` varchar(50) NOT NULL,
                    `category_status` tinyint(4) NOT NULL,
                    `category_description` longtext NOT NULL,
                    PRIMARY KEY (`category_id`)
                   ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8"
        );
    }

    public function deactivate() {
        $db = Pf::database();
        $db->query("DROP TABLE IF EXISTS `pf_portfolios`,`pf_portfolio_categories`,`pf_portfolio_meta`;");
    }

    public function public_init() {
        $shortcode = Pf::shortcode();
        require_once ABSPATH . "/includes/common/plugin/helpers/helper.php";
        $shortcode->add('portfolio', array($this, 'portfolio_list_category'));
    }

    function portfolio_list_category($atts, $content = null, $code = '') {
        $cat_id = !empty($_GET['portfolio-cat']) ? $_GET['portfolio-cat'] : '';
        if (empty($cat_id)) {
            $cat_id = !empty($atts['catid']) ? $atts['catid'] : '';
        }
        $portid = !empty($_GET['portfolio-id']) ? $_GET['portfolio-id'] : '';
        if (empty($portid)) {
            $portid = !empty($atts['portid']) ? $atts['portid'] : '';
        }
        ob_start();
        require_once abs_plugin_path(__FILE__) . "/portfolio/public/portfolio-public.php";
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }

    public function admin_init() {
        if (is_admin() or is_editor() or is_author()){
            $this->admin_menu('fa fa-caret-square-o-right', __('Portfolio', 'portfolio'), 'portfolio', 'plugin_portfolio');
            $this->admin_children_menu('fa fa-angle-double-right', __('Portfolio', 'portfolio'),'portfolio', 'plugin_portfolio', 'Portfolio');
            $this->admin_children_menu('fa fa-angle-double-right', __('Category', 'portfolio'),'category', 'plugin_portfolio', 'Portfolio');
        }
    }

    function plugin_portfolio() {
        if (is_admin() or is_editor() or is_author()) {
            
            $ref = array('admin-page' => 'portfolio');
            if (!empty($_GET['sub_page']))
                $ref['sub_page'] = $_GET['sub_page'];
            if (!empty($_GET['page']))
                $ref['page'] = $_GET['page'];
            if (!empty($_GET['port-name']))
                $ref['port-name'] = $_GET['port-name'];
            if (!empty($_GET['publish'])) $ref['publish']    =   $_GET['publish'];
            if (!empty($_GET['cat_id'])) $ref['cat_id']    =   $_GET['cat_id'];
            if (!empty($_GET['cat-name'])) $ref['cat-name']    =   $_GET['cat-name'];
            $status = array('1' => __('Published', 'portfolio'), '2' => __('Unpublished', 'portfolio'));
            $this->js('admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.pack.js');
            $this->css('admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.css');
            $this->css('admin/themes/default/assets/bootstrap-modal/css/animate.min.css');
            $this->js('admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js');
            $this->js('portfolio/assets/moment.js', __FILE__);
            $this->js('portfolio/assets/bootstrap-datetimepicker.js', __FILE__);
            $this->css('portfolio/assets/bootstrap-datetimepicker.css', __FILE__);
            $this->css('portfolio/assets/portfolio.css', __FILE__);
            $this->js('portfolio/assets/portfolio.js?t=' . uniqid(), __FILE__);
            $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );

            require_once abs_plugin_path(__FILE__) . "/portfolio/class/portfolio-class.php";
            if (isset($_GET['sub_page'])) {
                switch ($_GET['sub_page']) {
                    case 'category':
                        require_once abs_plugin_path(__FILE__) . "/portfolio/actions/category.php";
                        break;
                    case 'portfolio':
                        require_once abs_plugin_path(__FILE__) . "/portfolio/actions/portfolio.php";
                        break;
                }
            }
        } else
            echo __('Access Denied!','portfolio');
    }

}
